
# Touchpad client web application
### Control a computer using a touch-screen phone or tablet

#### Description
This web application runs on the cliend device, which acts as a touchpad
and controls a computer running the [server application](../../..).
A WebSocket connection is established to the g\_touchpad server to control the
mouse cursor on a computer.
Secure connections require a certificate file in the current directory with the
name `gvalkov.com.pem`.


#### Video demo [gTouchpad](https://youtu.be/-6GC3qK4poc)
[![gTouchpad](http://img.youtube.com/vi/-6GC3qK4poc/0.jpg)](https://youtu.be/-6GC3qK4poc)


#### Touchpad functions

| 1 finger gestures     | Action                                                     |
| :-------------------- | :--------------------------------------------------------- |
| move                  | Move mouse cursor                                          |
| press                 | Left button down                                           |
| release               | Left button up                                             |
| tap                   | Left button click                                          |
| tap and move          | Drag                                                       |
| hold                  | Right click                                                |
| tap and hold          | Left click and then right click                            |
| double tap then hold  | Double click and then right click                          |
| fast tap and hold     | Double click holding the left button and then right click; |
|                       | Release the finger to release the left button.             |
|                       | Useful to select a word, then open context menu:           |
|                       | copy, cut, pase, etc.                                      |
|                       | Releasing the finger will activate the selected menu item. |
|||
| **2 finger gestures** | **Action**                                                 |
| move                  | Scroll v \| h                                              |
| pinch                 | Zoom                                                       |
| hold                  | Middle click                                               |
| press                 | Right button down                                          |
| release               | Right button up                                            |
|||
| **3 finger gestures** | **Action**                                                 |
| move                  | Drag                                                       |
| hold                  | Drag lock, tap with 3 fingers to release the left button   |


#### Touchpad protocol

| Message              | Parameters        | Description |
| :------------------- | :---------------- | :---------- |
| down                 | *char*:`{LRMX}`   | Activate mouse button |
| down                 | L                 | Activate mouse button: Left |
| down                 | R                 | Activate mouse button: Right |
| down                 | M                 | Activate mouse button: Middle |
| down                 | X                 | Activate mouse button: Thumb (Back) |
| up                   | *char*:`{LRMX}`   | Deactivate mouse button |
| up                   | L                 | Deactivate mouse button: Left |
| up                   | R                 | Deactivate mouse button: Right |
| up                   | M                 | Deactivate mouse button: Middle |
| up                   | X                 | Deactivate mouse button: Thumb (Back) |
| touchstart           | *int*:X,*int*:Y   | Informational, does not do anything |
| touchend             |                   | Informational, does not do anything |
| touchcancel          |                   | Informational, does not do anything |
| touchmove            | *int*:dX,*int*:dY | Move the cursor |
| scroll               | *int*:dX,*int*:dY | Send a scroll event |
| zoom                 | *int*:dZ          | Send a zoom event |


#### Sample protocol
```powershell
touchstart 54,450   # touchstart at X=54, Y=450 (informational, ignored)
touchmove 0,-27     # touchmove dX=0, dY=-27
touchmove 0,-33
touchmove 1,-27
touchend            # touchend (informational, ignored)
touchstart 80,122
down L              # Activate mouse button: Left
touchend
up L                # Deactivate mouse button: Left
touchstart 223,121
down M, up M        # Click mouse button: Middle
touchstart 269,297
scroll -6,-40       # Send a scroll event dX=-6, dY=-40
scroll 0,-46
touchend
touchend
touchstart 262,67
touchstart 261,66
zoom -24            # Send a zoom event dZ=-24
zoom -26
zoom -23
```

#### Supported Platforms
☂︎ Apple iOS, macOS  
☂︎ FreeBSD  
☂︎ Linux  
☂︎ Windows  



#### Custom listening port and address for g\_touchpad
By default the web application tries to establish a web socket connection
to the same server which is hosting the web application, on port 81. To
specify a custom address, edit *index.htm*  
`g.msg.address = "ws://gvalkov.com:81/";`

#### Running the legacy *g\_touchpad.dll*
```
rundll32 g_touchpad.dll,rundll
rundll32 "c:\\path\\g_touchpad.dll",rundll
```

#### © 2015-2022 Georgi Valkov
https://httpstorm.com/download/g_touchpad/
